//-----------------------------------------------------------------------------
// mute.m
//
// Example of a mute button
//
// created by FrisbeeMonkey
//-----------------------------------------------------------------------------

//                            USING THIS SCRIPT:
//*****************************************************************************
//  1.  Define the following in your XML:
//    <togglebutton
//      id="Mute"
//      x="147" y="125"
//      image="player.MuteOff"
//      downImage="player.MuteOn"
//	    activeImage="player.MuteOn"
//      tooltip="Mute"
//    />
//         Change the position(x,y) to the specifics of your button,
//  2.  Make sure your ticker is called "SongTicker" and is in the same group as
//      "Mute"  If you don't have a ticker, add one now.
//  4.  Copy this script (and mute.maki) to your scripts folder.
//  5.  If you don't have mute.maki, compile this script.
//  6.  Add this line to the group that contains your animated layer
//        <script id="mute" file="scripts/mute.maki"/>
//  7.  Refresh your skin(F5) and try it out.
//*****************************************************************************

// never forget to include std.mi
#include "../../../lib/std.mi"

//declares volume functions
Function updateVolume(int v);

//declares global variables
Global Togglebutton MuteBtn;
Global Timer SongTickerTimer;
Global Text SongTicker;
Global Float VolumeLevel;
Global Boolean Muted;
Global Group pcGroup;

//When the script is loaded, do this
System.onScriptLoaded() {

	// Get the group that has the objects we want
	pcGroup = getScriptGroup();

	// Now that we have the group, get the objects in the group
	MuteBtn = pcGroup.findObject("Mute");
	SongTicker = pcGroup.findObject("songticker");

	// Initialize our timer
	SongTickerTimer = new Timer;
	SongTickerTimer.setDelay(500);

	//sets Muted flag to 0 since it starts off not muted
	Muted = 0;
}

// Clears text area
SongTickerTimer.onTimer() {
  SongTicker.setText("");
  SongTickerTimer.stop();
}

// If Mute is clicked, turn on or off
MuteBtn.onLeftButtonUp(int x, int y) {
	if (!Muted) { //If it isn't muted, mute it now
	//gets current volume, then sets volume to 0
		VolumeLevel = System.getVolume();
		System.setVolume(0);
		Muted = 1;
		SongTickerTimer.start();
		SongTicker.setText("Mute ON");
	} else { //unmute
	//set volume to the value saved before
		System.setVolume(VolumeLevel);
		Muted = 0;
		SongTickerTimer.start();
		SongTicker.setText("Mute OFF");
	}
}

// when the script is unloading, deletes the Timer
System.onScriptUnloading() {
	delete SongTickerTimer;
}